@extends('layouts.admin')

@section('title', 'View Content')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">View Content</h1>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.contents.edit', $content) }}" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('admin.contents.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="mb-3">
            <strong>Page Key:</strong>
            <p><code>{{ $content->page_key }}</code></p>
        </div>

        <div class="mb-3">
            <strong>Section:</strong>
            <p>{{ $content->section ?? 'N/A' }}</p>
        </div>

        <div class="mb-3">
            <strong>Label:</strong>
            <p>{{ $content->label }}</p>
        </div>

        <div class="mb-3">
            <strong>Type:</strong>
            <p><span class="badge bg-info">{{ $content->type }}</span></p>
        </div>

        <div class="mb-3">
            <strong>Content:</strong>
            <div class="mt-2 p-3 bg-light rounded">
                @if($content->type === 'html')
                    {!! $content->content !!}
                @elseif($content->type === 'image')
                    <img src="{{ $content->content }}" alt="{{ $content->label }}" class="img-fluid" style="max-width: 300px;">
                @else
                    <p>{{ $content->content }}</p>
                @endif
            </div>
        </div>

        <hr>

        <p><strong>Created:</strong> {{ $content->created_at->format('M d, Y h:i A') }}</p>
        <p><strong>Last Updated:</strong> {{ $content->updated_at->format('M d, Y h:i A') }}</p>
    </div>
</div>
@endsection



